/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.events.ARPProcessEventRegistry;
import com.cisco.pt.ipc.events.ActivityFileEventRegistry;
import com.cisco.pt.ipc.events.AppWindowEventRegistry;
import com.cisco.pt.ipc.events.CepInstanceEventRegistry;
import com.cisco.pt.ipc.events.CiscoDeviceEventRegistry;
import com.cisco.pt.ipc.events.CommandLogEventRegistry;
import com.cisco.pt.ipc.events.DHCPClientProcessEventRegistry;
import com.cisco.pt.ipc.events.DeviceEventRegistry;
import com.cisco.pt.ipc.events.EventThreadNotifier;
import com.cisco.pt.ipc.events.HTTPClientEventRegistry;
import com.cisco.pt.ipc.events.HostPortEventRegistry;
import com.cisco.pt.ipc.events.IPCManagerEventRegistry;
import com.cisco.pt.ipc.events.LogicalWorkspaceEventRegistry;
import com.cisco.pt.ipc.events.PLSwitchEventRegistry;
import com.cisco.pt.ipc.events.PingProcessEventRegistry;
import com.cisco.pt.ipc.events.Pop3ClientEventRegistry;
import com.cisco.pt.ipc.events.PopupMenuItemEventRegistry;
import com.cisco.pt.ipc.events.PortEventRegistry;
import com.cisco.pt.ipc.events.RSSwitchEventRegistry;
import com.cisco.pt.ipc.events.RemoteNetworkEventRegistry;
import com.cisco.pt.ipc.events.RoutingProcessEventRegistry;
import com.cisco.pt.ipc.events.STPProcessEventRegistry;
import com.cisco.pt.ipc.events.SimulationEventRegistry;
import com.cisco.pt.ipc.events.SmtpClientEventRegistry;
import com.cisco.pt.ipc.events.TerminalLineEventRegistry;
import com.cisco.pt.ipc.events.TreeNodeEventRegistry;
import com.cisco.pt.ipc.events.UserCreatedPDUEventRegistry;
import com.cisco.pt.ipc.events.VLANEventRegistry;
import com.cisco.pt.ipc.events.WebViewEventRegistry;
import com.cisco.pt.ipc.events.WebViewManagerEventRegistry;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IPCEventManager
extends Thread {
    protected PacketTracerSession session;
    public LinkedBlockingQueue<IPCEventLTV> eventQueue;
    public Semaphore locker = new Semaphore(0, true);
    private volatile boolean shouldStop = false;
    private EventThreadNotifier notifier = null;
    protected ARPProcessEventRegistry ARPProcessEvents;
    protected ActivityFileEventRegistry ActivityFileEvents;
    protected AppWindowEventRegistry AppWindowEvents;
    protected CepInstanceEventRegistry CepInstanceEvents;
    protected CiscoDeviceEventRegistry CiscoDeviceEvents;
    protected CommandLogEventRegistry CommandLogEvents;
    protected DHCPClientProcessEventRegistry DHCPClientProcessEvents;
    protected DeviceEventRegistry DeviceEvents;
    protected HTTPClientEventRegistry HTTPClientEvents;
    protected HostPortEventRegistry HostPortEvents;
    protected IPCManagerEventRegistry IPCManagerEvents;
    protected LogicalWorkspaceEventRegistry LogicalWorkspaceEvents;
    protected PLSwitchEventRegistry PLSwitchEvents;
    protected PingProcessEventRegistry PingProcessEvents;
    protected Pop3ClientEventRegistry Pop3ClientEvents;
    protected PopupMenuItemEventRegistry PopupMenuItemEvents;
    protected PortEventRegistry PortEvents;
    protected RSSwitchEventRegistry RSSwitchEvents;
    protected RemoteNetworkEventRegistry RemoteNetworkEvents;
    protected RoutingProcessEventRegistry RoutingProcessEvents;
    protected STPProcessEventRegistry STPProcessEvents;
    protected SimulationEventRegistry SimulationEvents;
    protected SmtpClientEventRegistry SmtpClientEvents;
    protected TerminalLineEventRegistry TerminalLineEvents;
    protected TreeNodeEventRegistry TreeNodeEvents;
    protected UserCreatedPDUEventRegistry UserCreatedPDUEvents;
    protected VLANEventRegistry VLANEvents;
    protected WebViewManagerEventRegistry WebViewManagerEvents;
    protected WebViewEventRegistry WebViewEvents;
    private static Log logger = LogFactory.getLog(IPCEventManager.class);

    public IPCEventManager(PacketTracerSession session) {
        this.eventQueue = new LinkedBlockingQueue();
        this.session = session;
        this.ARPProcessEvents = new ARPProcessEventRegistry(session);
        this.ActivityFileEvents = new ActivityFileEventRegistry(session);
        this.AppWindowEvents = new AppWindowEventRegistry(session);
        this.CepInstanceEvents = new CepInstanceEventRegistry(session);
        this.CiscoDeviceEvents = new CiscoDeviceEventRegistry(session);
        this.CommandLogEvents = new CommandLogEventRegistry(session);
        this.DHCPClientProcessEvents = new DHCPClientProcessEventRegistry(session);
        this.DeviceEvents = new DeviceEventRegistry(session);
        this.HTTPClientEvents = new HTTPClientEventRegistry(session);
        this.HostPortEvents = new HostPortEventRegistry(session);
        this.IPCManagerEvents = new IPCManagerEventRegistry(session);
        this.LogicalWorkspaceEvents = new LogicalWorkspaceEventRegistry(session);
        this.PLSwitchEvents = new PLSwitchEventRegistry(session);
        this.PingProcessEvents = new PingProcessEventRegistry(session);
        this.Pop3ClientEvents = new Pop3ClientEventRegistry(session);
        this.PopupMenuItemEvents = new PopupMenuItemEventRegistry(session);
        this.PortEvents = new PortEventRegistry(session);
        this.RSSwitchEvents = new RSSwitchEventRegistry(session);
        this.RemoteNetworkEvents = new RemoteNetworkEventRegistry(session);
        this.RoutingProcessEvents = new RoutingProcessEventRegistry(session);
        this.STPProcessEvents = new STPProcessEventRegistry(session);
        this.SimulationEvents = new SimulationEventRegistry(session);
        this.SmtpClientEvents = new SmtpClientEventRegistry(session);
        this.TerminalLineEvents = new TerminalLineEventRegistry(session);
        this.TreeNodeEvents = new TreeNodeEventRegistry(session);
        this.UserCreatedPDUEvents = new UserCreatedPDUEventRegistry(session);
        this.VLANEvents = new VLANEventRegistry(session);
        this.WebViewManagerEvents = new WebViewManagerEventRegistry(session);
        this.WebViewEvents = new WebViewEventRegistry(session);
    }

    public void processEvent(IPCEventLTV ltv) {
    }

    public void shouldStop() {
        this.shouldStop = true;
    }

    public void run() {
        while (!this.shouldStop) {
            IPCEventLTV ltv = null;
            try {
                ltv = this.eventQueue.take();
            }
            catch (InterruptedException e) {
                if (this.notifier != null) {
                    this.notifier.notify(e);
                }
                this.shouldStop = true;
                return;
            }
            try {
                String className = ltv.getClassName();
                if (className.equalsIgnoreCase("ArpProcess")) {
                    this.ARPProcessEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("ActivityFile")) {
                    this.ActivityFileEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("AppWindow")) {
                    this.AppWindowEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("CepInstance")) {
                    this.CepInstanceEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("CiscoDevice")) {
                    this.CiscoDeviceEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("CommandLog")) {
                    this.CommandLogEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("DhcpClientProcess")) {
                    this.DHCPClientProcessEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("Device")) {
                    this.DeviceEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("HttpClient")) {
                    this.HTTPClientEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("HostPort")) {
                    this.HostPortEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("IpcManager")) {
                    this.IPCManagerEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("LogicalWorkspace")) {
                    this.LogicalWorkspaceEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("PLSwitch")) {
                    this.PLSwitchEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("PingProcess")) {
                    this.PingProcessEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("Pop3Client")) {
                    this.Pop3ClientEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("MenuItem")) {
                    this.PopupMenuItemEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("Port")) {
                    this.PortEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("RSSwitch")) {
                    this.RSSwitchEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("RemoteNetwork")) {
                    this.RemoteNetworkEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("RoutingProcess")) {
                    this.RoutingProcessEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("StpProcess")) {
                    this.STPProcessEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("Simulation")) {
                    this.SimulationEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("SmtpClient")) {
                    this.SmtpClientEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("TerminalLine")) {
                    this.TerminalLineEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("TreeNode")) {
                    this.TreeNodeEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("UserCreatedPDU")) {
                    this.UserCreatedPDUEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("Vlan")) {
                    this.VLANEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("WebViewManager")) {
                    this.WebViewManagerEvents.processEvent(ltv);
                    continue;
                }
                if (className.equalsIgnoreCase("WebView")) {
                    this.WebViewEvents.processEvent(ltv);
                    continue;
                }
                logger.info((Object)("IPCEventManager received event with unrecognized className: " + className));
            }
            catch (Exception e) {
                if (this.notifier != null) {
                    this.notifier.notify(e);
                }
                this.shouldStop = true;
            }
        }
    }

    public void registerNotifier(EventThreadNotifier no) {
        this.notifier = no;
    }

    public ARPProcessEventRegistry getARPProcessEvents() {
        return this.ARPProcessEvents;
    }

    public ActivityFileEventRegistry getActivityFileEvents() {
        return this.ActivityFileEvents;
    }

    public AppWindowEventRegistry getAppWindowEvents() {
        return this.AppWindowEvents;
    }

    public CepInstanceEventRegistry getCepInstanceEvents() {
        return this.CepInstanceEvents;
    }

    public CiscoDeviceEventRegistry getCiscoDeviceEvents() {
        return this.CiscoDeviceEvents;
    }

    public CommandLogEventRegistry getCommandLogEvents() {
        return this.CommandLogEvents;
    }

    public DHCPClientProcessEventRegistry getDHCPClientProcessEvents() {
        return this.DHCPClientProcessEvents;
    }

    public DeviceEventRegistry getDeviceEvents() {
        return this.DeviceEvents;
    }

    public HTTPClientEventRegistry getHTTPClientEvents() {
        return this.HTTPClientEvents;
    }

    public HostPortEventRegistry getHostPortEvents() {
        return this.HostPortEvents;
    }

    public IPCManagerEventRegistry getIPCManagerEvents() {
        return this.IPCManagerEvents;
    }

    public LogicalWorkspaceEventRegistry getLogicalWorkspaceEvents() {
        return this.LogicalWorkspaceEvents;
    }

    public PLSwitchEventRegistry getPLSwitchEvents() {
        return this.PLSwitchEvents;
    }

    public PingProcessEventRegistry getPingProcessEvents() {
        return this.PingProcessEvents;
    }

    public Pop3ClientEventRegistry getPop3ClientEvents() {
        return this.Pop3ClientEvents;
    }

    public PopupMenuItemEventRegistry getPopupMenuItemEvents() {
        return this.PopupMenuItemEvents;
    }

    public PortEventRegistry getPortEvents() {
        return this.PortEvents;
    }

    public RSSwitchEventRegistry getRSSwitchEvents() {
        return this.RSSwitchEvents;
    }

    public RemoteNetworkEventRegistry getRemoteNetworkEvents() {
        return this.RemoteNetworkEvents;
    }

    public RoutingProcessEventRegistry getRoutingProcessEvents() {
        return this.RoutingProcessEvents;
    }

    public STPProcessEventRegistry getSTPProcessEvents() {
        return this.STPProcessEvents;
    }

    public SimulationEventRegistry getSimulationEvents() {
        return this.SimulationEvents;
    }

    public SmtpClientEventRegistry getSmtpClientEvents() {
        return this.SmtpClientEvents;
    }

    public TerminalLineEventRegistry getTerminalLineEvents() {
        return this.TerminalLineEvents;
    }

    public TreeNodeEventRegistry getTreeNodeEvents() {
        return this.TreeNodeEvents;
    }

    public UserCreatedPDUEventRegistry getUserCreatedPDUEvents() {
        return this.UserCreatedPDUEvents;
    }

    public VLANEventRegistry getVLANEvents() {
        return this.VLANEvents;
    }

    public WebViewManagerEventRegistry getWebViewManagerEvents() {
        return this.WebViewManagerEvents;
    }

    public WebViewEventRegistry getWebViewEvents() {
        return this.WebViewEvents;
    }
}

